/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.client.renderer;

import dev.satyrn.wolfarmor.WolfArmorMod;
import dev.satyrn.wolfarmor.api.entity.IFoodStatsCreature;
import dev.satyrn.wolfarmor.api.entity.passive.IArmoredWolf;
import dev.satyrn.wolfarmor.api.util.CreatureFoodStats;
import dev.satyrn.wolfarmor.util.WolfFoodStatsLevel;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Point;

@SideOnly(value=Side.CLIENT)
public class WolfRenderHelper {
    private static final int ICON_SIZE = 9;
    private static final Point ARMOR_FULL = new Point(34, 9);
    private static final Point ARMOR_HALF = new Point(25, 9);
    private static final Point ARMOR_EMPTY = new Point(16, 9);
    private static final int HEART_POISON_OFFSET_X = 36;
    private static final int HEART_WITHER_OFFSET_X = 72;
    private static final int HEART_ABSORPTION_FULL_OFFSET_X = 144;
    private static final int HEART_ABSORPTION_HALF_OFFSET_X = 153;
    private static final int HEART_FULL_OFFSET = 36;
    private static final int HEART_HALF_OFFSET = 45;
    private static final Point HEART_EMPTY = new Point(16, 0);
    private static final int FOOD_HUNGER_OFFSET_X = 36;
    private static final int FOOD_HUNGER_BG_MULT_X = 13;
    private static final int FOOD_FULL_OFFSET_X = 36;
    private static final int FOOD_HALF_OFFSET_X = 45;
    private static final Point FOOD_EMPTY = new Point(16, 27);

    public static void drawStats(@Nonnull EntityWolf wolf, boolean renderNameplate, double x, double y, double z, float playerViewX, float playerViewY, boolean isThirdPerson, boolean isSneaking) {
        if (!wolf.func_70909_n()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((isThirdPerson ? -1.0f : 1.0f) * playerViewX), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.01f, (float)-0.01f, (float)0.01f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179143_c((int)519);
        WolfRenderHelper.renderStats(wolf, 5, renderNameplate ? 22 : 0);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private static void drawIcon(int x, int y, int texX, int texY) {
        float pixelScale = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b((double)x, (double)(y + 9), 0.0).func_187315_a((double)((float)texX * 0.00390625f), (double)((float)(texY + 9) * 0.00390625f)).func_181675_d();
        builder.func_181662_b((double)(x + 9), (double)(y + 9), 0.0).func_187315_a((double)((float)(texX + 9) * 0.00390625f), (double)((float)(texY + 9) * 0.00390625f)).func_181675_d();
        builder.func_181662_b((double)(x + 9), (double)y, 0.0).func_187315_a((double)((float)(texX + 9) * 0.00390625f), (double)((float)texY * 0.00390625f)).func_181675_d();
        builder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)texX * 0.00390625f), (double)((float)texY * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void drawReversedIcon(int x, int y, int texX, int texY) {
        float pixelScale = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b((double)x, (double)(y + 9), 0.0).func_187315_a((double)((float)(texX + 9) * pixelScale), (double)((float)(texY + 9) * pixelScale)).func_181675_d();
        builder.func_181662_b((double)(x + 9), (double)(y + 9), 0.0).func_187315_a((double)((float)texX * pixelScale), (double)((float)(texY + 9) * pixelScale)).func_181675_d();
        builder.func_181662_b((double)(x + 9), (double)y, 0.0).func_187315_a((double)((float)texX * pixelScale), (double)((float)texY * pixelScale)).func_181675_d();
        builder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)(texX + 9) * pixelScale), (double)((float)texY * pixelScale)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawIcon(int x, int y, int texX, int texY, boolean reverse) {
        if (reverse) {
            WolfRenderHelper.drawReversedIcon(x, y, texX, texY);
        } else {
            WolfRenderHelper.drawIcon(x, y, texX, texY);
        }
    }

    private static void renderStats(EntityWolf wolf, int x, int y) {
        Point renderPos;
        int armorValue = wolf.func_70658_aO();
        int iconWidth = 9;
        int iconCount = 10;
        int xOffset = x + -iconWidth * iconCount / 2;
        int yOffset = y;
        if (((IArmoredWolf)wolf).getHasArmor() && armorValue > 0) {
            renderPos = WolfRenderHelper.renderArmor(wolf, new Point(xOffset, yOffset), false);
            yOffset = renderPos.getY();
        }
        renderPos = WolfRenderHelper.renderHealth(wolf, new Point(xOffset, yOffset), false);
        yOffset = renderPos.getY();
        if (WolfArmorMod.getConfig().getFoodStatsLevel() != WolfFoodStatsLevel.DISABLED) {
            WolfRenderHelper.renderHunger(wolf, new Point(xOffset, yOffset), false);
        }
    }

    public static Point renderArmor(EntityWolf wolf, Point coord, boolean reverse) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        int armorValue = wolf.func_70658_aO();
        int xInitial = reverse ? coord.getX() + 81 : coord.getX();
        for (int index = 0; index < 10; ++index) {
            int xOffset;
            int n = xOffset = reverse ? xInitial - index * 8 : xInitial + index * 8;
            if (index * 2 + 1 < armorValue) {
                WolfRenderHelper.drawIcon(xOffset, coord.getY(), ARMOR_FULL.getX(), ARMOR_FULL.getY(), reverse);
                continue;
            }
            if (index * 2 + 1 == armorValue) {
                WolfRenderHelper.drawIcon(xOffset, coord.getY(), ARMOR_HALF.getX(), ARMOR_HALF.getY(), reverse);
                continue;
            }
            if (index * 2 + 1 <= armorValue) continue;
            WolfRenderHelper.drawIcon(xOffset, coord.getY(), ARMOR_EMPTY.getX(), ARMOR_EMPTY.getY(), reverse);
        }
        return new Point(81 + coord.getX(), 10 + coord.getY());
    }

    public static Point renderHealth(EntityWolf wolf, Point coord, boolean reverse) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        int health = MathHelper.func_76123_f((float)wolf.func_110143_aJ());
        double maxHealth = wolf.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
        int absorption = MathHelper.func_76123_f((float)wolf.func_110139_bj());
        int heartRows = MathHelper.func_76143_f((double)((maxHealth + (double)absorption) / 2.0 / 10.0));
        int heartHeight = Math.max(10 - (heartRows - 2), 3);
        int xInitial = reverse ? coord.getX() + 81 : coord.getX();
        int currentAbsorption = absorption;
        int regenHeartIndex = -1;
        if (wolf.func_70644_a(MobEffects.field_76428_l)) {
            regenHeartIndex = wolf.field_70173_aa % MathHelper.func_76143_f((double)(maxHealth + 5.0));
        }
        for (int index = MathHelper.func_76143_f((double)((maxHealth + (double)absorption) / 2.0)) - 1; index >= 0; --index) {
            int texX = HEART_EMPTY.getX();
            if (wolf.func_70644_a(MobEffects.field_76436_u)) {
                texX += 36;
            } else if (wolf.func_70644_a(MobEffects.field_82731_v)) {
                texX += 72;
            }
            int heartRow = MathHelper.func_76123_f((float)(((float)index + 1.0f) / 10.0f)) - 1;
            int xOffset = reverse ? xInitial - index % 10 * 8 : xInitial + index % 10 * 8;
            int yOffset = coord.getY() + heartRow * heartHeight;
            if (health <= 2) {
                yOffset += wolf.func_70681_au().nextInt(2);
            }
            if (currentAbsorption <= 0 && index == regenHeartIndex) {
                yOffset -= 2;
            }
            WolfRenderHelper.drawIcon(xOffset, yOffset, HEART_EMPTY.getX(), HEART_EMPTY.getY(), reverse);
            if (currentAbsorption > 0) {
                if (currentAbsorption == absorption && absorption % 2 == 1) {
                    WolfRenderHelper.drawIcon(xOffset, yOffset, texX + 153, HEART_EMPTY.getY(), reverse);
                    --currentAbsorption;
                    continue;
                }
                WolfRenderHelper.drawIcon(xOffset, yOffset, texX + 144, HEART_EMPTY.getY(), reverse);
                currentAbsorption -= 2;
                continue;
            }
            if (index * 2 + 1 < health) {
                WolfRenderHelper.drawIcon(xOffset, yOffset, texX + 36, HEART_EMPTY.getY(), reverse);
                continue;
            }
            if (index * 2 + 1 != health) continue;
            WolfRenderHelper.drawIcon(xOffset, yOffset, texX + 45, HEART_EMPTY.getY(), reverse);
        }
        return new Point(81 + coord.getX(), heartHeight - 1 + coord.getY());
    }

    public static Point renderHunger(EntityWolf wolf, Point coord, boolean reverse) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        CreatureFoodStats foodStats = ((IFoodStatsCreature)wolf).getFoodStats();
        int foodLevel = foodStats.getFoodLevel();
        int xInitial = reverse ? coord.getX() + 81 : coord.getX();
        for (int index = 0; index < 10; ++index) {
            int xOffset = reverse ? xInitial - index * 8 : xInitial + index * 8;
            int yOffset = coord.getY();
            int texX = FOOD_EMPTY.getX();
            int hungerOffset = 0;
            if (wolf.func_70644_a(MobEffects.field_76438_s)) {
                texX += 36;
                hungerOffset = 13;
            }
            if (foodStats.getSaturationLevel() <= 0.0f && wolf.field_70173_aa % (foodLevel * 3 + 1) == 0) {
                yOffset += wolf.func_70681_au().nextInt(3) - 1;
            }
            WolfRenderHelper.drawIcon(xOffset, yOffset, FOOD_EMPTY.getX() + hungerOffset * 9, FOOD_EMPTY.getY(), !reverse);
            if (index * 2 + 1 < foodLevel) {
                WolfRenderHelper.drawIcon(xOffset, yOffset, texX + 36, FOOD_EMPTY.getY(), !reverse);
                continue;
            }
            if (index * 2 + 1 != foodLevel) continue;
            WolfRenderHelper.drawIcon(xOffset, yOffset, texX + 45, FOOD_EMPTY.getY(), !reverse);
        }
        return new Point(81 + coord.getX(), 10 + coord.getY());
    }
}

